<?php

namespace Database\Seeders;

use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use App\Models\api\v1\OrderStatus;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class OrderStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        if(OrderStatus::count() == 0)
        {
            OrderStatus::create([
                "uuid" => Str::uuid(),
                "name" => "CART",
                "step_number" => 1,
                "is_active"=> 1,
                "created_by"=> 1
            ]);

            OrderStatus::create([
                "uuid" => Str::uuid(),
                "name" => "CONFIRMED",
                "step_number" => 2,
                "is_active"=> 1,
                "created_by"=> 1
            ]);

            OrderStatus::create([
                "uuid" => Str::uuid(),
                "name" => "CANCELED",
                "step_number" => 2,
                "is_active"=> 1,
                "created_by"=> 1
            ]);


            OrderStatus::create([
                "uuid" => Str::uuid(),
                "name" => "PAID",
                "step_number" => 3,
                "is_active"=> 1,
                "created_by"=> 1
            ]);


            OrderStatus::create([
                "uuid" => Str::uuid(),
                "name" => "SERVED",
                "step_number" => 4,
                "is_active"=> 1,
                "created_by"=> 1
            ]);
        }
    }
}

