<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('access_tokens', function (Blueprint $table) {
            $table->id();
            $table->string('token',400);
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')
                ->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');

            $table->boolean('used')->default(false);
            $table->timestamp('used_at')->nullable();

            $table->timestamp('created_at')->useCurrent();
            $table->unsignedBigInteger('created_by');
            $table->foreign('created_by')
                ->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');



            $table->timestamp('expire_at')->nullable();

            $table->unsignedBigInteger('requester_api_key_id');
            $table->foreign('requester_api_key_id')
                ->references('id')->on('api_keys')->onUpdate('cascade')->onDelete('cascade');

            $table->unsignedBigInteger('authorized_api_key_id');
            $table->foreign('authorized_api_key_id')
                ->references('id')->on('api_keys')->onUpdate('cascade')->onDelete('cascade');
        
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('access_tokens');
    }
};
