<?php

namespace App\Services;

use Google\Client;
use Illuminate\Support\Facades\Log;


class PushNotificationService
{
    protected $projectId;
    protected $serviceAccount;

    public function __construct()
    {
        $this->projectId = config('firebase.project_id');
        $this->serviceAccount = config('firebase.service_account_json');
    }

    /**
     * Envoie une notification push via Firebase HTTP v1.
     *
     * @param string $deviceToken
     * @param string $title
     * @param string $body
     * @param array $data
     * @return array|string
     */
    public function sendNotification(string $deviceToken, string $title, string $body, array $data = [])
    {
        // Initialisation du client Google
        $googleClient = new Client();
        $googleClient->setAuthConfig($this->serviceAccount);
        $googleClient->addScope('https://www.googleapis.com/auth/firebase.messaging');
        // Obtenir le token d'accès
        $accessToken = $googleClient->fetchAccessTokenWithAssertion()['access_token'];
        // Construire l'URL de l'API
        $url = "https://fcm.googleapis.com/v1/projects/{$this->projectId}/messages:send";
        
        // Corps de la requête
        $payload = [
            'message' => [
                'token' => $deviceToken,
                'notification' => [
                    'title' => $title,
                    'body' => $body,
                ],
            ],
        ];
        if(!empty($data)){
            $payload["data"] = json_encode($data); // Données personnalisées
        }
        $headers = [
                'Authorization: Bearer '. $accessToken,
                'Content-Type: application/json',
            ];
        //////////Envoyer la requête 
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
        $response = curl_exec($ch);
        Log::info('Push Notification', ['data' => ["deviceToken" => $deviceToken, "title" => "title", "body" => $body, "response" => $response]]);
        return json_decode($response, true);
    }
}
