<?php

namespace App\Providers;

//use Illuminate\Support\ServiceProvider;

use App\Models\api\v1\Stock;
use App\Observers\StockObserver;
use Illuminate\Support\Facades\Schema;
use Laravel\Passport\Passport;
use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Carbon\Carbon;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Stock::observe(StockObserver::class);

        Schema::defaultStringLength(191);

        Carbon::setLocale('fr');
        //
        $this->registerPolicies();
        Passport::tokensExpireIn(now()->addMinute(1500));
        Passport::refreshTokensExpireIn(now()->addMinutes(500));
        Passport::personalAccessTokensExpireIn(now()->addMinutes(1500));
    }
}
