<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Model;

/**
 * @property integer $id
 * @property integer $susbcription_status_id
 * @property integer $susbcription_type_id
 * @property string $name
 * @property integer $owned_by
 * @property boolean $is_active
 * @property string $created_at
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $updated_at
 * @property boolean $is_deleted
 * @property string $deleted_at
 * @property integer $deleted_by
 * @property SubscriptionStatus $subscriptionStatus
 * @property SubscriptionType $subscriptionType
 * @property Transaction[] $transactions
 */
class Subscription extends Model
{
    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'integer';

    /**
     * @var array
     */
    protected $fillable = ['susbcription_status_id', 'susbcription_type_id', 'name', 'owned_by', 'is_active', 'created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];
    protected $hidden = [ 'created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function subscriptionStatus()
    {
        return $this->belongsTo('App\Models\api\v1\SubscriptionStatus', 'susbcription_status_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function subscriptionType()
    {
        return $this->belongsTo('App\Models\api\v1\SubscriptionType', 'susbcription_type_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function transactions()
    {
        return $this->hasMany('App\Models\api\v1\Transaction');
    }
}
