<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Model;

/**
 * @property integer $id
 * @property integer $stock_id
 * @property integer $order_id
 * @property float $quantity
 * @property int $created_by
 * @property string $created_at
 * @property int $updated_by
 * @property string $updated_at
 * @property Order $order
 * @property Stock $stock
 */
class LineItem extends Model
{
    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'integer';

    /**
     * @var array
     */
    protected $fillable = ['stock_id', 'order_id', 'quantity', 'created_by', 'created_at', 'updated_by', 'updated_at'];
    protected $hidden = ['created_at', 'created_by', 'updated_by', 'updated_at'];


    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->created_by = auth()->user()->id ??  null;
            $model->updated_by = auth()->user()->id ??  null;
            $model->created_at = now();
            // $model->reference = Str::random(12);
        });

        static::updating(function ($model) {
            $model->created_by = auth()->user()->id ??  null;
            $model->updated_by = auth()->user()->id ??  null;
            $model->updated_at = now();
            dump($model->order);
            // $model->reference = Str::random(12);
        });
    }
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo('App\Models\api\v1\Order');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function stock()
    {
        return $this->belongsTo('App\Models\api\v1\Stock');
    }
}
