<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Model;

/**
 * @property integer $id
 * @property int $country_id
 * @property integer $payment_mode_id
 * @property boolean $is_active
 * @property string $created_at
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $updated_at
 * @property boolean $is_deleted
 * @property string $deleted_at
 * @property integer $deleted_by
 * @property Country $country
 * @property PaymentMode $paymentMode
 * @property Wallet[] $wallets
 */
class CountryPaymentMode extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'countries_payment_modes';

    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'integer';

    /**
     * @var array
     */
    protected $fillable = ['country_id', 'payment_mode_id', 'is_active', 'created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];
    protected $hidden = [ 'created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country()
    {
        return $this->belongsTo('App\Models\api\v1\Country');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function paymentMode()
    {
        return $this->belongsTo('App\Models\api\v1\PaymentMode');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function wallets()
    {
        return $this->hasMany('App\Models\api\v1\Wallet', 'country_payment_mode_id');
    }
}
