<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Resources\Json\ResourceCollection;

class ItemResource extends ResourceCollection
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'        => $this->id,
            'uuid'        => $this->uuid,
            'size'        => $this->size,
            'unit'        => $this->unit,
            'name'        => $this->name,
            'description'        => $this->description,
            'img_1'        => $this->img_1,
            //'provider'        => $this->provider ?? null,
            //'country'        => $this->country ?? null,
            'links' => [
                'self' => 'link-value',
            ],
        ];
    }
}

