<?php

namespace App\Http\Controllers\api\v1;

use App\Constant\ConstantField;
use App\Helpers\NotificationHelpers;
use App\Helpers\SerializerHelpers;
use App\Models\api\v1\AccessTokens;
use App\Models\api\v1\ApiKey;
use App\Models\User;
use App\Services\ApiKeyService;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\api\v1\Device;
use App\Models\api\v1\Order;
use App\Models\api\v1\OrderStatus;
use App\Models\api\v1\Transaction;
use App\Models\api\v1\TransactionStatus;
use App\Models\api\v1\TransactionType;
use App\Models\api\v1\UserRole;
use App\Models\api\v1\UsersRolesSpace;
use App\Models\api\v1\Wallet;
use App\Services\CinetPayService;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;






class TransactionController extends Controller
{

    /**
     * Gestion des callback CinetPay
     */
    public function processingCallbackCinetPay(Request $request)
    {
        $data = $request->all();
        $isOk = false;
        $transaction = Transaction::where('uuid', $data['cpm_trans_id'])->first();
        if (!empty($transaction) && $transaction->amount_paid == $data['cpm_amount']) {
            if ($transaction->type == 1) {
                $this->processingUpdateOrder($transaction, $data);
            } else {
                return $this->processingRefillHostpost($transaction);
            }
        }
        if (!$isOk) {
            return response()->json(['success' => false, "message" => "Echec de mise à jour de la transaction"]);
        }
        return response()->json(['success' => true, "message" => "Mise a jour effectuée avec succès"]);
    }

    public function paidPass(Request $request)
    {
        if (empty($request->phone)) {
            return  redirect()->back()->with("errors", "Numéro de telephone requis");
        }
        $phone = $request->phone;
        $trans_status = TransactionStatus::where('name', 'INIT')->first();
        $wallet = Wallet::where('name', 'CINETPAY')->first();
        $trans_type = TransactionType::where('name', "ONLINE")->first();
        $data = [
            "uuid" => Str::uuid()->toString(),
            "amount_paid" => 2000,
            "order_id"    => null,
            "transaction_status_id" => $trans_status->id,
            "wallet_id" => $wallet->id,
            "transaction_type_id" => $trans_type->id,
            "request" => "",
            "response" => "",
            "callback_response" => "",
            "type" => 2,
            "phone" => $phone,
            "created_by" => 15000,
        ];
        $transaction = Transaction::create($data);
        try {
            $cinetData = [
                "amount"       => 2000,
                "description"   => "Paiement Pass",
                "libelle"   => "Paiement Pass",
                "transaction_id"   => $transaction->uuid,
                "name"   => "Pass Customer",
                "tel"   => $phone,
                "return_url"   => "https://motherafricafestival.com/success",
            ];
            $payment = new CinetPayService();
            $urlPay = $payment->generatePaymentLink($cinetData);
            if ($urlPay["code"] == '201') {
                $url = $urlPay["data"]["payment_url"];
                $data = [
                    "request" => $urlPay['request'],
                    "response" => $urlPay['response'],
                    "callback_response" => "",
                ];
                Transaction::where('uuid', $transaction->uuid)->update($data);
                return redirect()->away($url, 301);
            }
        } catch (\Exception $e) {
            return  redirect()->back()->with("errors", "Une erreur s'est produite");
        }
    }

    private function processingUpdateOrder($transaction, $data)
    {
        $order = Order::where('id', $transaction->order_id)->first();
        if (!empty($order) && $order->order_status_id != OrderStatus::where("name", "CONFIRMED")->first()->id) {
            return response()->json(['success' => false, "message" => "Commande deja traitée"]);
        }
        $cinetpay = new CinetPayService();
        $cinetpay->processingCallback($data, $isOk);
        if ($isOk) {
            $transaction->callback_response = json_encode($data);
            $transaction->transaction_status_id = TransactionStatus::where('name', "APPROVED")->first()->id;
            $transaction->save();
            ///////////update order
            $order->order_status_id = OrderStatus::where("name", "PAID")->first()->id;
            $order->save();
            $this->sendNotifs($order);
        }
    }

    private function processingRefillHostpost($transaction)
    {
        $user_phone = $transaction->phone;
        $subscription_name = "Offre 30 minutes gratuites";
        $zone_name = "EVENT MOTHERS AFRICA";
        $data = ["user_phone" => $user_phone, "subscription_name" => $subscription_name, "zone_name" => $zone_name];
        $hotspot = new HostpostController();
        $isOk = false;
        $response = $hotspot->registerCustomerMother($data, $isOk);
        if ($isOk) {
            $customer_email = $response['customer_email'];
            $refillData = ["zone_name" => $zone_name, "subscription_name" => $subscription_name, "phone" => $customer_email];
            $isOk = false;
            $hotspot->customeRefillMother($refillData, $isOk);
            Log::info("Rechargement effectué avec succès", ['data' => $user_phone]);
            return response()->json(['success' => true, "message" => "Rechargement effectué avec succès"]);
        }
        Log::info("Echec de rechargement", ['data' => $user_phone]);
        return response()->json(['success' => false, "message" => "Echec de rechargement"]);
    }

    private function sendNotifs($order)
    {
        $userIds = array();
        if (empty($order)) {
            return;
        }
        $clientId = $order->customer->id;
        array_push($userIds, $clientId);
        //////merchands 
        $userInSpace = UsersRolesSpace::where('space_id', $order->space_id)->get()->pluck('user_role_id');
        $userRoles = UserRole::whereIn('id', $userInSpace)->where('role_id', 3)->get();
        foreach ($userRoles as $userRole) {
            if (!in_array($userRole?->user?->id, $userIds)) {
                array_push($userIds, $userRole?->user?->id);
            }
        }
        $devicesTokens = Device::whereIn('user_id', $userIds)->get()->pluck('device_token')->toArray();
        if (!empty($devicesTokens)) {
            // NotificationHelpers::sendNotification(
            //     [$devicesTokens],
            //     "Information sur la commande ",
            //     "Paiement de la commande N°" . $order->order_number . " effectué avec succès",
            //     ["Action" => "", "order_mumber" => $order->order_number]
            // );
        }
    }

    private function getFlexData(string $token): array
    {

        return $data = [
            "solde" => 30,
            'transactions' => [
                [
                    "id" => 124,
                    "montant" => 10,
                    "type" => "SORTANT",
                    "commentaire" => "Test de paiement marchand",
                    "statut" => "valide",
                    "etat" => "valide",
                    "user" => 720,
                    "ref" => "pay659c20e5150ab",
                    "partenaire" => 38,
                    "transaction" => "transaction",
                    "created_at" => "2024-01-08 16:20:53",
                    "updated_at" => "2024-01-08 16:20:56",
                    "avantages" => null,
                    "beneficiaire" => "KY KADER",
                    "label" => "KY KADER",
                    "nature" => "Paiement",
                    "operateur" => ""
                ],
                [
                    "id" => 122,
                    "montant" => 10,
                    "type" => "SORTANT",
                    "commentaire" => "Test de paiement marchand",
                    "statut" => "valide",
                    "etat" => "valide",
                    "user" => 720,
                    "ref" => "con6598f531d6e66",
                    "partenaire" => 38,
                    "transaction" => "transaction",
                    "created_at" => "2024-01-08 16:20:53",
                    "updated_at" => "2024-01-08 16:20:56",
                    "avantages" => null,
                    "beneficiaire" => "KY KADER",
                    "label" => "KY KADER",
                    "nature" => "Paiement",
                    "operateur" => ""
                ]
            ]
        ];
    }

    /**
     * Generate and Send Code
     */
    public function list(Request $request): JsonResponse
    {

        $get_authorized_api_key = ApiKey::where([['name', 'Flex'], ['is_active', 1]])->first();
        if (!$get_authorized_api_key) {
            return $this->ReturnResponse(false, "An error occurred. Please try again!", [], 401);
        }


        //@TODO:
        $access_token = AccessTokens::create([
            'user_id'               => $request->user()->id,
            'token'                 => Str::random(350),
            'created_by'            => $request->user()->id,
            'expire_at'             => now()->addSeconds(ApiKeyService::getApiKey($request)->token_max_interval),
            'requester_api_key_id'  => ApiKeyService::getApiKey($request)->id,
            'authorized_api_key_id' => $get_authorized_api_key->id,
            'used'                  => 0
        ]);

        $data = $this->getFlexData($access_token->token);

        return $this->ReturnResponse(true, "List Transactions", $data, 200);
    }


    public function userDetails(Request $request, string $token): JsonResponse
    {

        $access_token = AccessTokens::where([
            ['token',                   $token],
            ['used',                    0],
            ['expire_at',  '>=',        Carbon::now()],
            ['authorized_api_key_id',   ApiKeyService::getApiKey($request)->id]
        ])->first();

        if (!$access_token) {
            return $this->ReturnResponse(false, "Token is not valid", [], 401);
        }

        $user = User::find($access_token->user_id);

        $access_token->update([
            'used'      => 1,
            'used_at'   => now(),
        ]);

        return $this->ReturnResponse(true, "User Details", SerializerHelpers::serializeUser($user));
    }
}
